(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4421,        144]*)
(*NotebookOutlinePosition[      5546,        180]*)
(*  CellTagsIndexPosition[      5418,        173]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(BinomPDF[k_, N_, dt_, f_] := 
      PDF[BinomialDistribution[N, 1 - Exp[\(-f\)*dt]], k]\)], "Input"],

Cell[BoxData[
    \(Trigger1[nTh_, N_, dt_, f_] := 
      Evaluate[Sum[
            BinomPDF[k, N, 5/10^9, f]*
              BinomPDF[nTh - k, N, dt, 
                f]*\((1 - Sum[BinomPDF[j, N, 5/10^9, f], {j, 0, k}])\), {k, 
              0, nTh}]]*\((10^9/5)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?BinomPDF\)\)], "Input"],

Cell["Global`BinomPDF", "Print",
  CellTags->"Info3362315879-8409761"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(BinomPDF[k_, N_, dt_, f_] := 
                    PDF[BinomialDistribution[N, 
                        1 - \[ExponentialE]\^\(\(-f\)\ dt\)], k]\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ "BinomPDF"],
      Editable->False]], "Print",
  CellTags->"Info3362315879-8409761"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Trigger1\)\)], "Input"],

Cell[BoxData[
    \(Information::"notfound" \(\(:\)\(\ \)\) 
      "Symbol \!\(\"Trigger1\"\) not found."\)], "Message"]
}, Open  ]],

Cell[BoxData[
    \(Trigger1[nTh_, N_, dt_, f_] := 
      Evaluate[Sum[
            BinomPDF[k, N, 0.0001/10^9, f]*
              BinomPDF[nTh - k, N, dt, 
                f]*\((1 - 
                  Sum[BinomPDF[j, N, 0.0001/10^9, f], {j, 0, k}])\), {k, 0, 
              nTh}]]*\((10^9/0.0001)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Trigger1\)\)], "Input"],

Cell["Global`Trigger1", "Print",
  CellTags->"Info3362315904-1598254"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(Trigger1[nTh_, N_, dt_, f_] := 
                    1\/5\ Evaluate[\[Sum]\+\(k = 0\)\%nTh BinomPDF[k, N, 
                              5\/10\^9, f]\ BinomPDF[nTh - k, N, dt, 
                              f]\ \((1 - \[Sum]\+\(j = 0\)\%k BinomPDF[j, N, 
                                    5\/10\^9, f])\)]\ 10\^9\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ "Trigger1"],
      Editable->False]], "Print",
  CellTags->"Info3362315904-1598254"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[Trigger1[249, 81000, 425/10^9, 6\ 10^3]]\)], "Input"],

Cell[BoxData[
    \(192707.40988527454`\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{495, 527},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Info3362315879-8409761"->{
    Cell[2179, 67, 70, 1, 25, "Print",
      CellTags->"Info3362315879-8409761"],
    Cell[2252, 70, 568, 15, 44, "Print",
      CellTags->"Info3362315879-8409761"]},
  "Info3362315904-1598254"->{
    Cell[3426, 112, 70, 1, 25, "Print",
      CellTags->"Info3362315904-1598254"],
    Cell[3499, 115, 738, 17, 77, "Print",
      CellTags->"Info3362315904-1598254"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Info3362315879-8409761", 5027, 159},
  {"Info3362315904-1598254", 5224, 164}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 120, 2, 50, "Input"],
Cell[1828, 54, 277, 6, 130, "Input"],

Cell[CellGroupData[{
Cell[2130, 64, 46, 1, 30, "Input"],
Cell[2179, 67, 70, 1, 25, "Print",
  CellTags->"Info3362315879-8409761"],
Cell[2252, 70, 568, 15, 44, "Print",
  CellTags->"Info3362315879-8409761"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2857, 90, 46, 1, 30, "Input"],
Cell[2906, 93, 120, 2, 24, "Message"]
}, Open  ]],
Cell[3041, 98, 311, 7, 130, "Input"],

Cell[CellGroupData[{
Cell[3377, 109, 46, 1, 30, "Input"],
Cell[3426, 112, 70, 1, 25, "Print",
  CellTags->"Info3362315904-1598254"],
Cell[3499, 115, 738, 17, 77, "Print",
  CellTags->"Info3362315904-1598254"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4274, 137, 75, 1, 30, "Input"],
Cell[4352, 140, 53, 1, 29, "Output"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

